<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Subject;

class FixPracticalStatus extends Command
{
    protected $signature = 'fix:practical-status';
    protected $description = 'Sync has_practical flag from papers to subject';

    public function handle()
    {
        $subjects = Subject::with('papers')->get();
        foreach ($subjects as $subject) {
            $hasPractical = $subject->papers->contains('has_practical', 1);
            $subject->update(['has_practical' => $hasPractical ? 1 : 0]);
            $this->info("Updated {$subject->name}: " . ($hasPractical ? 'YES' : 'NO'));
        }
        $this->info('Done.');
    }
}
