<?php

namespace App\Http\Controllers;

use App\Models\Student;
use App\Models\FinalResult;
use App\Models\Notice;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    /**
     * Display the dashboard.
     */
    public function index()
    {
        $stats = [
            'students' => Student::count(),
            'teachers' => \App\Models\Teacher::count(),
            'batches' => \App\Models\Batch::count(),
            'exams' => \App\Models\Exam::count(),
            'notices' => Notice::count(),
            'pending_results' => \App\Models\Exam::where('status', '!=', 'completed')->count(),
        ];

        $recentStudents = Student::latest()->take(5)->get();
        $recentNotices = Notice::latest()->take(5)->get();
        // $recentResults = FinalResult::with(['student', 'exam'])->latest()->take(5)->get(); // Optional if needed

        return view('admin.dashboard', compact('stats', 'recentStudents', 'recentNotices'));
    }
}

