<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreStudentRequest extends FormRequest
{
    public function authorize()
    {
        return true; // Use policy in controller
    }

    public function rules()
    {
        return [
            'name' => 'required|string|max:255',
            'father_name' => 'required|string|max:255',
            'mother_name' => 'required|string|max:255',
            'date_of_birth' => 'required|date',
            'gender' => 'required|in:Male,Female',
            'ssc_reg_no' => 'required|string|unique:students,ssc_reg_no',
            'ssc_batch' => 'required|integer|min:2000|max:2099',
            'class' => 'required|in:11,12', // Mapping to Classes XI/XII
            'group_code' => 'required|in:1,2,3', // 1=Arts, 2=Commerce, 3=Science
            'academic_version_id' => 'required|exists:academic_versions,id',
            'batch_id' => 'nullable|exists:batches,id',
            'phone' => 'nullable|string|max:20',
            'email' => 'nullable|email|max:255',
            'address' => 'nullable|string',
            'photo' => 'nullable|image|max:2048', // 2MB
            // Subject Assignment
            'fourth_subject_id' => [
                'nullable', 
                'exists:subjects,id',
                // validation to ensure it is allowing as 4th subject logic in Service
            ],
            'optional_subjects' => 'nullable|array',
            'optional_subjects.*' => 'exists:subjects,id',
        ];
    }
}
