<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateStudentRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        $studentId = $this->route('student')->id;

        return [
            'name' => 'required|string|max:255',
            'father_name' => 'required|string|max:255',
            'mother_name' => 'required|string|max:255',
            'date_of_birth' => 'required|date',
            'gender' => 'required|in:Male,Female',
            'ssc_reg_no' => [
                'required', 
                'string',
                Rule::unique('students', 'ssc_reg_no')->ignore($studentId)
            ],
            // Critical fields usually read-only or Restricted
            'ssc_batch' => 'sometimes|integer|min:2000|max:2099',
            'class' => 'sometimes|in:11,12',
            'group_code' => 'sometimes|in:1,2,3',
            'academic_version_id' => 'sometimes|exists:academic_versions,id',
            
            'batch_id' => 'nullable|exists:batches,id',
            'status' => 'required|in:active,inactive,alumni',
            'phone' => 'nullable|string|max:20',
            'email' => 'nullable|email|max:255',
            'address' => 'nullable|string',
            'photo' => 'nullable|image|max:2048',
             // Subject updates might be handled separately or here
            'fourth_subject_id' => 'nullable|exists:subjects,id',
        ];
    }
}
