<?php

namespace App\Imports;

use App\Models\Student;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;

class StudentsImport implements ToModel, WithHeadingRow, WithValidation
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        return new Student([
            'name'    => $row['name'],
            'roll'    => $row['roll'],
            'class'   => $row['class'],
            'section' => $row['section'] ?? null,
            'year'    => $row['year'],
            'group'   => $row['group'] ?? null,
            'phone'   => $row['phone'] ?? null,
            'email'   => $row['email'] ?? null,
            'address' => $row['address'] ?? null,
        ]);
    }

    /**
     * Validation rules
     */
    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'roll' => 'required|string|max:255',
            'class' => 'required|string|max:255',
            'section' => 'nullable|string|max:255',
            'year' => 'required|string|max:255',
            'group' => 'nullable|in:Science,Arts,Commerce',
            'phone' => 'nullable|string|max:255',
            'email' => 'nullable|email|max:255',
            'address' => 'nullable|string',
        ];
    }
}

