<?php

namespace App\Jobs;

use App\Models\Student;
use App\Models\Batch;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;

class BulkPromoteStudentsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $studentIds;
    protected $targetBatchId;
    protected $targetClass;
    protected $targetSession;

    /**
     * Create a new job instance.
     */
    public function __construct(array $studentIds, $targetBatchId, $targetClass, $targetSession)
    {
        $this->studentIds = $studentIds;
        $this->targetBatchId = $targetBatchId;
        $this->targetClass = $targetClass; // 12
        $this->targetSession = $targetSession; // 2026-2027
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $targetBatch = Batch::find($this->targetBatchId);

        // Chunk processing
        collect($this->studentIds)->chunk(50)->each(function ($chunk) use ($targetBatch) {

            Student::whereIn('id', $chunk)->each(function ($student) use ($targetBatch) {

                // Archive current state? Or just update. 
                // Typically you might want to log this or create a history record.
                // For this implementation, we simply update.

                $student->update([
                    'batch_id' => $this->targetBatchId,
                    'class' => $this->targetClass,
                    'session' => $this->targetSession,
                    // 'status' => 'promoted', // Maybe?
                ]);
            });
        });
    }
}
