<?php

namespace App\Jobs;

use App\Models\Exam;
use App\Models\FinalResult;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class CalculatePositionsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $exam;

    /**
     * Create a new job instance.
     */
    public function __construct(Exam $exam)
    {
        $this->exam = $exam;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $allResults = FinalResult::where('exam_id', $this->exam->id)
            ->orderByDesc('gpa')
            ->orderByDesc('total_marks')
            ->get();

        $position = 1;
        $previousGpa = null;
        $previousTotalMarks = null;

        foreach ($allResults as $result) {
            // Handle tied positions (same GPA and total marks)
            if (
                $previousGpa !== null &&
                $result->gpa == $previousGpa &&
                $result->total_marks == $previousTotalMarks
            ) {
                // Same position as previous
                $result->update(['position' => $position - 1]);
            } else {
                // New position
                $result->update(['position' => $position]);
                $previousGpa = $result->gpa;
                $previousTotalMarks = $result->total_marks;
                $position++;
            }
        }
    }
}
