<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\SoftDeletes;

class AcademicVersion extends Model
{
    use SoftDeletes;
    
    protected $guarded = ['id'];
    
    protected $casts = [
        'effective_from' => 'date',
        'is_current' => 'boolean',
    ];

    // Relationships
    public function blueprints()
    {
        return $this->hasMany(SubjectBlueprint::class);
    }

    public function examTemplates()
    {
        return $this->hasMany(ExamTemplate::class);
    }
}
