<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Alumni extends Model
{
    use HasFactory;

    protected $table = 'alumni';

    protected $fillable = [
        'student_id',
        'session',
        'hsc_year',
        'hsc_roll',
        'hsc_result',
        'passing_year',
        'current_status',
        'contact_info',
        'notes',
    ];

    protected $casts = [
        'hsc_year' => 'integer',
        'passing_year' => 'integer',
    ];

    /**
     * Get the student that owns this alumni record
     */
    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    /**
     * Get the academic session
     */
    public function academicSession()
    {
        return $this->belongsTo(AcademicSession::class, 'session', 'session');
    }

    /**
     * Scope to filter by HSC year
     */
    public function scopeByHscYear($query, $year)
    {
        return $query->where('hsc_year', $year);
    }

    /**
     * Scope to filter by session
     */
    public function scopeBySession($query, $session)
    {
        return $query->where('session', $session);
    }

    /**
     * Scope to filter by passing year
     */
    public function scopeByPassingYear($query, $year)
    {
        return $query->where('passing_year', $year);
    }

    /**
     * Get alumni with contact info
     */
    public function scopeWithContact($query)
    {
        return $query->whereNotNull('contact_info');
    }
}
