<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
// use Illuminate\Database\Eloquent\SoftDeletes;

class Exam extends Model
{
    // use SoftDeletes; // Disabled by user request

    protected $guarded = ['id'];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
    ];

    // Relationships
    public function batch()
    {
        return $this->belongsTo(Batch::class);
    }

    public function examTemplate()
    {
        return $this->belongsTo(ExamTemplate::class, 'exam_template_id');
    }

    public function marks()
    {
        return $this->hasMany(ResultMark::class);
    }

    public function finalResults()
    {
        return $this->hasMany(FinalResult::class);
    }

    public function subjectRules()
    {
        return $this->hasMany(ExamSubjectRule::class);
    }
}
