<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ExamTemplate extends Model
{
    protected $guarded = ['id'];

    protected $casts = [
        'rules' => 'array',
    ];

    public function version()
    {
        return $this->belongsTo(AcademicVersion::class, 'academic_version_id');
    }

    public function exams()
    {
        return $this->hasMany(Exam::class);
    }

    public function subjectRules()
    {
        return $this->hasMany(ExamTemplateSubjectRule::class);
    }
}
