<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ExamTemplateSubjectRule extends Model
{
    use HasFactory;

    protected $fillable = [
        'exam_template_id',
        'subject_id',
        'paper_mode',
        'config',
        'total_marks',
        'pass_marks',
    ];

    protected $casts = [
        'config' => 'array',
    ];

    public function template()
    {
        return $this->belongsTo(ExamTemplate::class, 'exam_template_id');
    }

    public function subject()
    {
        return $this->belongsTo(Subject::class);
    }
}


