<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class GroupSubject extends Model
{
    protected $guarded = ['id'];

    protected $casts = [
        'is_mandatory' => 'boolean',
    ];

    public function version()
    {
        return $this->belongsTo(AcademicVersion::class, 'academic_version_id');
    }

    public function subject()
    {
        return $this->belongsTo(Subject::class);
    }
}
