<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Notice extends Model
{
    use SoftDeletes;

    protected $guarded = ['id'];

    protected $casts = [
        'published_at' => 'datetime',
        'is_active' => 'boolean',
    ];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function category()
    {
        return $this->belongsTo(NoticeCategory::class, 'notice_category_id');
    }

    public function scopeSearch($query, $search)
    {
        return $query->where('title', 'like', "%{$search}%");
    }

    public function scopeByCategory($query, $categoryId)
    {
        return $query->where('notice_category_id', $categoryId);
    }


    public function scopePinnedFirst($query)
    {
        return $query->orderByDesc('is_pinned');
    }
}
