<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Subject extends Model
{
    use SoftDeletes;

    protected $guarded = ['id'];

    // Relationships
    public function papers()
    {
        return $this->hasMany(SubjectPaper::class);
    }

    public function blueprints()
    {
        return $this->hasMany(SubjectBlueprint::class);
    }

    // Scopes
    public function scopeActive($query)
    {
        // Status column does not exist, relying on SoftDeletes
        return $query;
    }

    public function scopeFourthSubjects($query)
    {
        // Assuming non-core subjects can be 4th subject
        return $query->where('type', '!=', 'core');
    }

    public function scopeForGroup($query, $group)
    {
        return $query->where('type', $group);
    }

    public function students()
    {
        return $this->belongsToMany(Student::class, 'student_subjects');
    }


    // Accessors for View Logic
    public function getHasSecondPaperAttribute()
    {
        return $this->has_multiple_papers;
    }

    public function getHasMcqAttribute()
    {
        // If has manual papers, check first paper
        $p1 = $this->papers->where('paper_type', '!=', 'second')->first();
        return $p1 ? $p1->has_mcq : false;
    }

    public function getHasCqAttribute()
    {
        $p1 = $this->papers->where('paper_type', '!=', 'second')->first();
        return $p1 ? $p1->has_cq : false;
    }

    /*
    public function getHasPracticalAttribute()
    {
        // Use DB column if consistent, or check papers
        // We recently synced DB column, so use that.
        return $this->attributes['has_practical'] ?? false;
    } 
    */
    // View uses $subject->has_practical, which matches DB column.

    public function getHasSecondPaperMcqAttribute()
    {
        $p2 = $this->papers->where('paper_type', 'second')->first();
        return $p2 ? $p2->has_mcq : false;
    }

    public function getHasSecondPaperCqAttribute()
    {
        $p2 = $this->papers->where('paper_type', 'second')->first();
        return $p2 ? $p2->has_cq : false;
    }

    public function getHasSecondPaperPracticalAttribute()
    {
        $p2 = $this->papers->where('paper_type', 'second')->first();
        return $p2 ? $p2->has_practical : false;
    }
}
