<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SubjectBlueprint extends Model
{
    protected $guarded = ['id'];

    protected $casts = [
        'components' => 'array',
        'pass_rules' => 'array',
    ];

    public function subject()
    {
        return $this->belongsTo(Subject::class);
    }

    public function version()
    {
        return $this->belongsTo(AcademicVersion::class, 'academic_version_id');
    }
}
