<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        \App\Models\Notice::observe(\App\Observers\CacheObserver::class);
        \App\Models\HeroSlide::observe(\App\Observers\CacheObserver::class);
        \App\Models\Teacher::observe(\App\Observers\CacheObserver::class);
        \App\Models\Setting::observe(\App\Observers\CacheObserver::class);


        // Share global settings with all views - execute immediately in boot
        $defaults = [
            'college_name' => 'Sheikh Abdul Wohab Model College',
            'site_logo' => 'frontend/assets/img/logo.png',
            'site_favicon' => 'frontend/assets/img/favicon.png',
            'footer_about' => 'We are committed to providing quality education.',
            'social_facebook' => '#',
            'social_youtube' => '#',
            'social_twitter' => '#',
            'social_instagram' => '#',
            'contact_full_address' => 'College Road, BD',
            'contact_office_phone' => '+8801...',
            'contact_general_email' => 'info@example.com',
        ];

        // Fetch ALL settings from DB
        try {
             $db_settings = \App\Models\Setting::pluck('value', 'key')->toArray();
        } catch (\Exception $e) {
             $db_settings = [];
        }
        
        // Clean paths to remove /admin/public/ prefix and keep only from 'storage/' onwards
        if (!empty($db_settings['site_logo'])) {
            $path = str_replace('\\', '/', $db_settings['site_logo']);
            if (strpos($path, 'storage/') !== false) {
                $db_settings['site_logo'] = substr($path, strpos($path, 'storage/'));
            }
        }
        if (!empty($db_settings['site_favicon'])) {
            $path = str_replace('\\', '/', $db_settings['site_favicon']);
            if (strpos($path, 'storage/') !== false) {
                $db_settings['site_favicon'] = substr($path, strpos($path, 'storage/'));
            }
        }

        // Clean Map URL on read to handle messy inputs immediately
        if (!empty($db_settings['contact_map_url'])) {
             // Case 1: Full iframe code
             if (preg_match('/src="([^"]+)"/', $db_settings['contact_map_url'], $match)) {
                $db_settings['contact_map_url'] = $match[1];
            } 
            // Case 2: URL with trailing attributes/quotes
            elseif (strpos($db_settings['contact_map_url'], '"') !== false) {
                $db_settings['contact_map_url'] = substr($db_settings['contact_map_url'], 0, strpos($db_settings['contact_map_url'], '"'));
            }
        }
        
        $settings = array_merge($defaults, $db_settings);
        
        // Share with all views using View::share
        \Illuminate\Support\Facades\View::share('global_settings', $settings);
    }
}

