<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('teachers', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('designation'); // e.g., Principal, Vice Principal, Teacher
            $table->string('department')->nullable(); // e.g., Science, Arts, Commerce
            $table->text('qualification')->nullable(); // Educational qualifications
            $table->text('specialization')->nullable(); // Subject specialization
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->text('bio')->nullable(); // Brief biography
            $table->string('photo')->nullable(); // Photo path
            $table->integer('display_order')->default(0); // For ordering (principal should be first)
            $table->boolean('is_active')->default(true);
            $table->boolean('is_principal')->default(false); // Highlight principal
            $table->timestamps();
            
            // Add indexes
            $table->index('is_principal');
            $table->index('is_active');
            $table->index('display_order');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('teachers');
    }
};

