<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // 1. Academic Versions (Rule Set Versioning)
        Schema::create('academic_versions', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique(); // e.g., "v1_2024"
            $table->date('effective_from');
            $table->boolean('is_current')->default(false);
            $table->text('description')->nullable();
            $table->timestamps();
        });

        // 2. Batches (HSC Batches) - No session dependency, just entry/graduation years
        Schema::create('batches', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique(); // e.g., "HSC 2024"
            $table->year('entry_year');
            $table->year('graduation_year')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('batches');
        Schema::dropIfExists('academic_versions');
    }
};
