<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // 1. Subjects (Master List)
        Schema::create('subjects', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique(); // e.g., "101"
            $table->string('name'); // e.g., "Bangla 1st Paper"
            $table->enum('type', ['core', 'science', 'arts', 'commerce'])->default('core');
            $table->boolean('has_practical')->default(false);
            $table->timestamps();
            $table->softDeletes();
        });

        // 2. Subject Blueprints (Versioned Rules)
        Schema::create('subject_blueprints', function (Blueprint $table) {
            $table->id();
            $table->foreignId('subject_id')->constrained()->cascadeOnDelete();
            $table->foreignId('academic_version_id')->constrained('academic_versions')->cascadeOnDelete();
            
            $table->integer('total_marks')->default(100);
            $table->integer('pass_marks')->default(33);
            
            // JSON storing component-wise marks: {"cq": 60, "mcq": 30, "practical": 10}
            $table->json('components')->nullable(); 
            
            // JSON storing pass rules: {"cq": 20, "mcq": 10, "practical": 3}
            $table->json('pass_rules')->nullable(); 
            
            $table->timestamps();
            
            $table->unique(['subject_id', 'academic_version_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('subject_blueprints');
        Schema::dropIfExists('subjects');
    }
};
