<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // 1. Notices
        Schema::create('notices', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->enum('category', ['general', 'exam', 'admission', 'event'])->default('general');
            $table->text('content')->nullable();
            
            $table->enum('attachment_type', ['pdf', 'link', 'none'])->default('none');
            $table->string('attachment_path')->nullable(); // PDF path or URL
            
            $table->timestamp('published_at')->nullable();
            $table->boolean('is_active')->default(true);
            
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            
            $table->timestamps();
            $table->softDeletes();
            
            $table->index('is_active');
        });

        // 2. Gallery Albums
        Schema::create('gallery_albums', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->string('thumbnail')->nullable();
            $table->boolean('is_featured')->default(false);
            $table->integer('order')->default(0);
            $table->timestamps();
        });

        // 3. Gallery Items (Media)
        Schema::create('gallery_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('album_id')->constrained('gallery_albums')->cascadeOnDelete();
            $table->enum('type', ['image', 'video'])->default('image');
            $table->string('path'); // Image path or Video URL/ID
            $table->string('caption')->nullable();
            $table->integer('order')->default(0);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('gallery_items');
        Schema::dropIfExists('gallery_albums');
        Schema::dropIfExists('notices');
    }
};
