<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('subjects', function (Blueprint $table) {
            if (!Schema::hasColumn('subjects', 'status')) {
                $table->enum('status', ['active', 'inactive'])->default('active')->after('is_4th_subject_eligible');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('subjects', function (Blueprint $table) {
             if (Schema::hasColumn('subjects', 'status')) {
                $table->dropColumn('status');
             }
        });
    }
};
