<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::dropIfExists('subject_bucket_items');
        Schema::dropIfExists('subject_buckets');

        Schema::create('subject_electives', function (Blueprint $table) {
            $table->id();
            $table->foreignId('academic_version_id')->constrained()->cascadeOnDelete();
            $table->string('group_code'); // science, commerce, arts
            $table->foreignId('subject_id')->constrained()->cascadeOnDelete();
            $table->timestamps();

            $table->unique(['academic_version_id', 'group_code', 'subject_id'], 'unique_elective_subject');
        });
    }

    public function down()
    {
        Schema::dropIfExists('subject_electives');
        // Irreversible data loss for buckets is acceptable as we are refactoring for production
    }
};
