<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('notices', function (Blueprint $table) {
            // 1. Drop the old enum column
            $table->dropColumn('category');
            
            // 2. Add the new foreign key column
            $table->foreignId('notice_category_id')->nullable()->after('title')->constrained('notice_categories')->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('notices', function (Blueprint $table) {
            $table->dropForeign(['notice_category_id']);
            $table->dropColumn('notice_category_id');
            $table->enum('category', ['general', 'exam', 'admission', 'event'])->default('general');
        });
    }
};
