<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('subjects', function (Blueprint $table) {
            // Fix: Add 'type' if missing (New Schema)
            if (!Schema::hasColumn('subjects', 'type')) {
                // If we have 'group' (Old Schema), we can use it to populate 'type' later or just add 'type'
                $table->string('type')->default('core')->after('name');
            }
            
            // Fix: Add 'status' if missing (Old Code might rely on it, though we removed it from Model)
            // Actually we REMOVED it from Model, so we don't need it.
            
            // Fix: Ensure SoftDeletes (Both schemas had it, but verify)
            if (!Schema::hasColumn('subjects', 'deleted_at')) {
                $table->softDeletes();
            }
        });

        // Migrate Data: If 'group' exists and 'type' is default 'core', map 'group' -> 'type'
        if (Schema::hasColumn('subjects', 'group') && Schema::hasColumn('subjects', 'type')) {
            // Map values: Science->science, Commerce->commerce...
            // Old 'group' enum: ['Science', 'Arts', 'Commerce', 'Core']
            // New 'type' enum: ['core', 'science', 'arts', 'commerce']
            DB::statement("UPDATE subjects SET type = LOWER(`group`) WHERE type = 'core' AND `group` IS NOT NULL");
        }
    }

    public function down(): void
    {
        // No down needed for fix
    }
};
