<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('result_marks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('exam_id')->constrained()->onDelete('cascade');
            $table->foreignId('student_id')->constrained()->onDelete('cascade');
            $table->foreignId('subject_id')->constrained()->onDelete('cascade');
            $table->decimal('first_paper_mcq', 8, 2)->nullable();
            $table->decimal('first_paper_cq', 8, 2)->nullable();
            $table->decimal('first_paper_practical', 8, 2)->nullable();
            $table->decimal('second_paper_mcq', 8, 2)->nullable();
            $table->decimal('second_paper_cq', 8, 2)->nullable();
            $table->decimal('second_paper_practical', 8, 2)->nullable();
            $table->decimal('total_marks', 8, 2);
            $table->decimal('subject_gpa', 3, 2);
            $table->string('subject_grade', 5);
            $table->boolean('is_failed')->default(false);
            $table->timestamps();
            
            $table->unique(['exam_id', 'student_id', 'subject_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('result_marks');
    }
};
