<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('final_results', function (Blueprint $table) {
            if (!Schema::hasColumn('final_results', 'total_marks')) {
                $table->decimal('total_marks', 8, 2)->after('student_id');
            }
            if (!Schema::hasColumn('final_results', 'gpa')) {
                $table->decimal('gpa', 3, 2)->after('total_marks');
            }
            if (!Schema::hasColumn('final_results', 'grade')) {
                $table->string('grade', 5)->after('gpa');
            }
            if (!Schema::hasColumn('final_results', 'position')) {
                $table->integer('position')->nullable()->after('grade');
            }
            if (!Schema::hasColumn('final_results', 'remarks')) {
                $table->text('remarks')->nullable()->after('position');
            }
            if (!Schema::hasColumn('final_results', 'is_published')) {
                $table->boolean('is_published')->default(false)->after('remarks');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('final_results', function (Blueprint $table) {
            $table->dropColumn(['position', 'remarks', 'is_published', 'total_marks', 'gpa', 'grade']);
        });
    }
};
