<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('results', function (Blueprint $table) {
            $table->id();
            $table->foreignId('student_id')->nullable()->constrained()->onDelete('set null');
            $table->string('roll')->index();
            $table->string('class');
            $table->string('year');
            $table->string('student_name');
            $table->decimal('total_marks', 8, 2);
            $table->string('grade', 10);
            $table->text('remarks')->nullable();
            $table->timestamps();
            
            // Add composite index for efficient result search
            $table->index(['roll', 'class', 'year']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('results');
    }
};

