<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subjects', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('code')->unique();
            $table->enum('group', ['Science', 'Arts', 'Commerce', 'Core'])->default('Core');
            $table->boolean('is_4th_subject')->default(false);
            $table->boolean('has_first_paper')->default(true);
            $table->boolean('has_second_paper')->default(false);
            $table->boolean('has_mcq')->default(false);
            $table->boolean('has_cq')->default(true);
            $table->boolean('has_practical')->default(false);
            $table->integer('total_marks')->default(100);
            $table->integer('pass_marks')->default(33);
            $table->integer('mcq_marks')->nullable();
            $table->integer('cq_marks')->nullable();
            $table->integer('practical_marks')->nullable();
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subjects');
    }
};

