<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('notices', function (Blueprint $table) {
            $table->foreignId('category_id')->nullable()->after('department')->constrained('notice_categories')->nullOnDelete();
            $table->enum('priority', ['low', 'normal', 'high', 'urgent'])->default('normal')->after('category_id');
            $table->boolean('is_instant')->default(false)->after('priority'); // Instant notification
            $table->boolean('is_pinned')->default(false)->after('is_instant'); // Pin to top
            $table->timestamp('published_at')->nullable()->after('is_active'); // Scheduled publishing
            $table->timestamp('expires_at')->nullable()->after('published_at'); // Auto expire
            $table->integer('views_count')->default(0)->after('expires_at');
            $table->text('meta_keywords')->nullable()->after('views_count');
            $table->string('target_audience')->nullable()->after('meta_keywords'); // e.g., "students", "teachers", "all"
            
            $table->index('category_id');
            $table->index('priority');
            $table->index('is_pinned');
            $table->index('published_at');
            $table->index('expires_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('notices', function (Blueprint $table) {
            $table->dropForeign(['category_id']);
            $table->dropIndex(['category_id']);
            $table->dropIndex(['priority']);
            $table->dropIndex(['is_pinned']);
            $table->dropIndex(['published_at']);
            $table->dropIndex(['expires_at']);
            
            $table->dropColumn([
                'category_id',
                'priority',
                'is_instant',
                'is_pinned',
                'published_at',
                'expires_at',
                'views_count',
                'meta_keywords',
                'target_audience'
            ]);
        });
    }
};

