<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('result_templates', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Template name (e.g., "HSC Science 2024")
            $table->string('description')->nullable();
            $table->string('class'); // 11 or 12
            $table->json('subjects'); // Array of subject IDs included in this template
            $table->json('grading_rules')->nullable(); // Custom grading rules if any
            $table->boolean('is_default')->default(false); // Is this the default template
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('result_templates');
    }
};
