<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('result_templates', function (Blueprint $table) {
            // Subject-wise detailed configurations
            $table->json('subject_configs')->nullable()->after('subjects');
            
            // Grading system configuration
            $table->json('grade_points')->nullable()->after('grading_rules');
            
            // Pass criteria
            $table->integer('minimum_pass_marks')->default(33)->after('grade_points');
            $table->decimal('minimum_gpa', 3, 2)->default(1.00)->after('minimum_pass_marks');
            
            // Template type and settings
            $table->string('template_type')->default('standard')->after('class'); // standard, advanced, custom
            $table->boolean('allow_absent')->default(true)->after('template_type');
            $table->boolean('strict_pass_all_subjects')->default(true)->after('allow_absent');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('result_templates', function (Blueprint $table) {
            $table->dropColumn([
                'subject_configs',
                'grade_points',
                'minimum_pass_marks',
                'minimum_gpa',
                'template_type',
                'allow_absent',
                'strict_pass_all_subjects',
            ]);
        });
    }
};
