<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Drop foreign keys first
        Schema::table('student_subjects', function (Blueprint $table) {
            $table->dropForeign(['subject_id']);
        });
        
        Schema::table('result_marks', function (Blueprint $table) {
            $table->dropForeign(['subject_id']);
        });
        
        // Drop related tables
        Schema::dropIfExists('student_subjects');
        
        // Drop subjects table
        Schema::dropIfExists('subjects');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Recreate subjects table
        Schema::create('subjects', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('code')->unique();
            $table->enum('group', ['Science', 'Arts', 'Commerce', 'Core'])->default('Core');
            $table->boolean('is_4th_subject')->default(false);
            $table->boolean('has_first_paper')->default(true);
            $table->boolean('has_second_paper')->default(false);
            $table->boolean('has_mcq')->default(false);
            $table->boolean('has_cq')->default(true);
            $table->boolean('has_practical')->default(false);
            $table->integer('total_marks')->nullable();
            $table->integer('mcq_marks')->nullable();
            $table->integer('cq_marks')->nullable();
            $table->integer('practical_marks')->nullable();
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->timestamps();
        });
        
        // Recreate student_subjects table
        Schema::create('student_subjects', function (Blueprint $table) {
            $table->id();
            $table->foreignId('student_id')->constrained()->onDelete('cascade');
            $table->foreignId('subject_id')->constrained()->onDelete('cascade');
            $table->string('year');
            $table->timestamps();
            $table->unique(['student_id', 'year']);
        });
    }
};
