<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('subjects', function (Blueprint $table) {
            if (!Schema::hasColumn('subjects', 'has_mcq')) {
                $table->boolean('has_mcq')->default(false)->after('has_second_paper');
            }
            if (!Schema::hasColumn('subjects', 'has_cq')) {
                $table->boolean('has_cq')->default(true)->after('has_mcq');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('subjects', function (Blueprint $table) {
            $table->dropColumn(['has_mcq', 'has_cq']);
        });
    }
};
