<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('subjects', function (Blueprint $table) {
            if (!Schema::hasColumn('subjects', 'second_paper_code')) {
                $table->string('second_paper_code')->nullable()->after('has_cq');
            }
            if (!Schema::hasColumn('subjects', 'has_second_paper_mcq')) {
                $table->boolean('has_second_paper_mcq')->default(false)->after('second_paper_code');
            }
            if (!Schema::hasColumn('subjects', 'has_second_paper_cq')) {
                $table->boolean('has_second_paper_cq')->default(true)->after('has_second_paper_mcq');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('subjects', function (Blueprint $table) {
            $table->dropColumn(['second_paper_code', 'has_second_paper_mcq', 'has_second_paper_cq']);
        });
    }
};
