<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('exam_template_subject_rules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('exam_template_id')->constrained('exam_templates')->cascadeOnDelete();
            $table->foreignId('subject_id')->constrained('subjects')->cascadeOnDelete();
            $table->enum('paper_mode', ['separate', 'merged']);
            $table->json('config');
            $table->unsignedInteger('total_marks');
            $table->unsignedInteger('pass_marks');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('exam_template_subject_rules');
    }
};


