<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('academic_sessions', function (Blueprint $table) {
            $table->id();
            $table->string('session')->unique(); // e.g., "2023-2024"
            $table->integer('hsc_year'); // e.g., 2025
            $table->integer('total_students')->default(0);
            $table->integer('active_students')->default(0);
            $table->integer('promoted_students')->default(0);
            $table->integer('failed_students')->default(0);
            $table->integer('left_students')->default(0);
            $table->integer('alumni_students')->default(0);
            $table->decimal('pass_rate', 5, 2)->nullable(); // e.g., 92.50
            $table->enum('status', ['ongoing', 'completed'])->default('ongoing');
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->timestamps();
            
            $table->index('session');
            $table->index('hsc_year');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('academic_sessions');
    }
};
