<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('alumni', function (Blueprint $table) {
            $table->id();
            $table->foreignId('student_id')->constrained()->onDelete('cascade');
            $table->string('session'); // e.g., "2023-2024"
            $table->integer('hsc_year'); // e.g., 2025
            $table->string('hsc_roll')->nullable();
            $table->string('hsc_result')->nullable(); // e.g., "A+", "GPA 5.00"
            $table->integer('passing_year')->nullable();
            $table->string('current_status')->nullable(); // e.g., "University", "Job"
            $table->text('contact_info')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
            
            $table->index('student_id');
            $table->index('session');
            $table->index('hsc_year');
            $table->index('passing_year');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('alumni');
    }
};
