<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('batch_statistics', function (Blueprint $table) {
            $table->id();
            $table->string('session'); // e.g., "2023-2024"
            $table->foreignId('exam_id')->constrained()->onDelete('cascade');
            $table->integer('total_students')->default(0);
            $table->integer('appeared')->default(0);
            $table->integer('passed')->default(0);
            $table->integer('failed')->default(0);
            $table->decimal('average_marks', 6, 2)->nullable();
            $table->integer('highest_marks')->nullable();
            $table->integer('lowest_marks')->nullable();
            $table->decimal('pass_rate', 5, 2)->nullable();
            $table->timestamps();
            
            $table->index('session');
            $table->index('exam_id');
            $table->unique(['session', 'exam_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('batch_statistics');
    }
};
