<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('students', function (Blueprint $table) {
            // Add indexes for better query performance
            $table->index('session', 'students_session_index');
            $table->index('status', 'students_status_index');
            $table->index('current_class', 'students_current_class_index');
            $table->index(['session', 'current_class'], 'students_session_class_index');
            $table->index(['session', 'status'], 'students_session_status_index');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('students', function (Blueprint $table) {
            $table->dropIndex('students_session_index');
            $table->dropIndex('students_status_index');
            $table->dropIndex('students_current_class_index');
            $table->dropIndex('students_session_class_index');
            $table->dropIndex('students_session_status_index');
        });
    }
};
