<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // Extend enum to include 'alumni'
        DB::statement("ALTER TABLE `students` MODIFY `status` ENUM('active','promoted','failed','left','alumni') NOT NULL DEFAULT 'active'");
    }

    public function down(): void
    {
        // Revert enum to previous set without 'alumni'
        DB::statement("ALTER TABLE `students` MODIFY `status` ENUM('active','promoted','failed','left') NOT NULL DEFAULT 'active'");
    }
};
