<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Batch;

class BatchSeeder extends Seeder
{
    public function run()
    {
        $batches = [
            [
                'name' => 'HSC 2024',
                'is_active' => true,
            ],
            [
                'name' => 'HSC 2025',
                'is_active' => true,
            ],
            [
                'name' => 'HSC 2023',
                'is_active' => false,
            ],
        ];

        foreach ($batches as $batch) {
            Batch::firstOrCreate(
                ['name' => $batch['name']],
                $batch
            );
        }
    }
}
