<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;

class MinimalHscSubjectsSeeder extends Seeder
{
    public function run(): void
    {
        $now = now();
        $subjects = [
            // Core
            ['Bangla 1st Paper','BAN-101','Core', true, false, false, false],
            ['Bangla 2nd Paper','BAN-102','Core', false, true, false, false],
            ['English 1st Paper','ENG-101','Core', true, false, false, false],
            ['English 2nd Paper','ENG-102','Core', false, true, false, false],
            ['ICT (Information & Communication Technology)','ICT-101','Core', true, false, true, false],

            // Science
            ['Physics 1st Paper','PHY-101','Science', true, false, true, false],
            ['Physics 2nd Paper','PHY-102','Science', false, true, true, false],
            ['Chemistry 1st Paper','CHE-101','Science', true, false, true, false],
            ['Chemistry 2nd Paper','CHE-102','Science', false, true, true, false],
            ['Biology 1st Paper','BIO-101','Science', true, false, true, false],
            ['Biology 2nd Paper','BIO-102','Science', false, true, true, false],
            ['Higher Mathematics 1st Paper','MAT-101','Science', true, false, false, true], // Often 4th subject
            ['Higher Mathematics 2nd Paper','MAT-102','Science', false, true, false, true],

            // Arts
            ['History of Bangladesh & World Civilization 1st Paper','HIS-101','Arts', true, false, false, false],
            ['History of Bangladesh & World Civilization 2nd Paper','HIS-102','Arts', false, true, false, false],
            ['Civics 1st Paper','CIV-101','Arts', true, false, false, false],
            ['Civics 2nd Paper','CIV-102','Arts', false, true, false, false],
            ['Economics 1st Paper','ECO-101','Arts', true, false, false, false],
            ['Economics 2nd Paper','ECO-102','Arts', false, true, false, false],

            // Commerce
            ['Accounting 1st Paper','ACC-101','Commerce', true, false, false, false],
            ['Accounting 2nd Paper','ACC-102','Commerce', false, true, false, false],
            ['Business Organization & Management 1st Paper','BOM-101','Commerce', true, false, false, false],
            ['Business Organization & Management 2nd Paper','BOM-102','Commerce', false, true, false, false],
            ['Finance, Banking & Insurance 1st Paper','FIN-101','Commerce', true, false, false, false],
            ['Finance, Banking & Insurance 2nd Paper','FIN-102','Commerce', false, true, false, false],
        ];

        foreach ($subjects as [$name,$code,$group,$hasFirst,$hasSecond,$hasPractical,$is4th]) {
            DB::table('subjects')->updateOrInsert(
                ['code' => $code],
                [
                    'name' => $name,
                    'group' => $group,
                    'has_first_paper' => $hasFirst,
                    'has_second_paper' => $hasSecond,
                    'has_practical' => $hasPractical,
                    'is_4th_subject' => $is4th,
                    'status' => 'active',
                    'updated_at' => $now,
                    'created_at' => $now,
                ]
            );
        }
    }
}
