<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Student;

class StudentsHscSeeder extends Seeder
{
    public function run(): void
    {
        $students = [
            // Session 2023-2024 (HSC 2025), current_class 11
            [
                'name' => 'Arif Hasan', 'roll' => '1101', 'class' => '11', 'current_class' => '11',
                'session' => '2023-2024', 'year' => '2024', 'status' => 'active', 'group' => 'Science',
                'phone' => '+880170000001', 'email' => 'arif.hasan@example.com', 'address' => 'Dhaka'
            ],
            [
                'name' => 'Nusrat Jahan', 'roll' => '1102', 'class' => '11', 'current_class' => '11',
                'session' => '2023-2024', 'year' => '2024', 'status' => 'active', 'group' => 'Science',
                'phone' => '+880170000002', 'email' => 'nusrat.j@example.com', 'address' => 'Dhaka'
            ],
            [
                'name' => 'Rakib Ahmed', 'roll' => '1103', 'class' => '11', 'current_class' => '11',
                'session' => '2023-2024', 'year' => '2024', 'status' => 'active', 'group' => 'Arts',
                'phone' => '+880170000003', 'email' => 'rakib.ahmed@example.com', 'address' => 'Chattogram'
            ],
            [
                'name' => 'Shila Khatun', 'roll' => '1104', 'class' => '11', 'current_class' => '11',
                'session' => '2023-2024', 'year' => '2024', 'status' => 'active', 'group' => 'Commerce',
                'phone' => '+880170000004', 'email' => 'shila.k@example.com', 'address' => 'Rajshahi'
            ],
            [
                'name' => 'Mahmudul Hasan', 'roll' => '1105', 'class' => '11', 'current_class' => '11',
                'session' => '2023-2024', 'year' => '2024', 'status' => 'active', 'group' => 'Science',
                'phone' => '+880170000005', 'email' => 'mahmudul@example.com', 'address' => 'Sylhet'
            ],

            // Session 2024-2025 (HSC 2026), some already in 12
            [
                'name' => 'Tanjina Akter', 'roll' => '1201', 'class' => '11', 'current_class' => '12',
                'session' => '2024-2025', 'year' => '2025', 'status' => 'promoted', 'group' => 'Science',
                'phone' => '+880170000006', 'email' => 'tanjina@example.com', 'address' => 'Mymensingh'
            ],
            [
                'name' => 'Sabbir Hossain', 'roll' => '1202', 'class' => '11', 'current_class' => '12',
                'session' => '2024-2025', 'year' => '2025', 'status' => 'promoted', 'group' => 'Arts',
                'phone' => '+880170000007', 'email' => 'sabbir@example.com', 'address' => 'Khulna'
            ],
            [
                'name' => 'Sumaiya Islam', 'roll' => '1203', 'class' => '11', 'current_class' => '12',
                'session' => '2024-2025', 'year' => '2025', 'status' => 'promoted', 'group' => 'Commerce',
                'phone' => '+880170000008', 'email' => 'sumaiya@example.com', 'address' => 'Barishal'
            ],
            [
                'name' => 'Farhan Chowdhury', 'roll' => '1204', 'class' => '11', 'current_class' => '12',
                'session' => '2024-2025', 'year' => '2025', 'status' => 'promoted', 'group' => 'Science',
                'phone' => '+880170000009', 'email' => 'farhan@example.com', 'address' => 'Rangpur'
            ],
            [
                'name' => 'Priya Saha', 'roll' => '1205', 'class' => '11', 'current_class' => '12',
                'session' => '2024-2025', 'year' => '2025', 'status' => 'promoted', 'group' => 'Arts',
                'phone' => '+880170000010', 'email' => 'priya@example.com', 'address' => 'Cumilla'
            ],
        ];

        foreach ($students as $data) {
            Student::firstOrCreate([
                'roll' => $data['roll'], 'session' => $data['session']
            ], $data);
        }
    }
}
