<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class SubjectsSeeder extends Seeder
{
    /**
     * Run the database seeder.
     */
    public function run(): void
    {
        $now = Carbon::now();
        
        $subjects = [
            // ==================== CORE SUBJECTS (Common for All Groups) ====================
            [
                'name' => 'Bangla 1st Paper',
                'code' => 'BAN-101',
                'group' => 'Core',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Bangla 2nd Paper',
                'code' => 'BAN-102',
                'group' => 'Core',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'English 1st Paper',
                'code' => 'ENG-101',
                'group' => 'Core',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'English 2nd Paper',
                'code' => 'ENG-102',
                'group' => 'Core',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'ICT (Information & Communication Technology)',
                'code' => 'ICT-101',
                'group' => 'Core',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => true,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 30,
                'cq_marks' => 50,
                'practical_marks' => 20,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],

            // ==================== SCIENCE GROUP SUBJECTS ====================
            [
                'name' => 'Physics 1st Paper',
                'code' => 'PHY-101',
                'group' => 'Science',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => true,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 50,
                'practical_marks' => 25,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Physics 2nd Paper',
                'code' => 'PHY-102',
                'group' => 'Science',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => true,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 50,
                'practical_marks' => 25,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Chemistry 1st Paper',
                'code' => 'CHE-101',
                'group' => 'Science',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => true,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 50,
                'practical_marks' => 25,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Chemistry 2nd Paper',
                'code' => 'CHE-102',
                'group' => 'Science',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => true,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 50,
                'practical_marks' => 25,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Biology 1st Paper',
                'code' => 'BIO-101',
                'group' => 'Science',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => true,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 50,
                'practical_marks' => 25,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Biology 2nd Paper',
                'code' => 'BIO-102',
                'group' => 'Science',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => true,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 50,
                'practical_marks' => 25,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Higher Mathematics 1st Paper',
                'code' => 'MAT-101',
                'group' => 'Science',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => false,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => null,
                'cq_marks' => 100,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Higher Mathematics 2nd Paper',
                'code' => 'MAT-102',
                'group' => 'Science',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => false,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => null,
                'cq_marks' => 100,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],

            // ==================== ARTS GROUP SUBJECTS ====================
            [
                'name' => 'History of Bangladesh & World Civilization 1st Paper',
                'code' => 'HIS-101',
                'group' => 'Arts',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'History of Bangladesh & World Civilization 2nd Paper',
                'code' => 'HIS-102',
                'group' => 'Arts',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Islamic History & Culture 1st Paper',
                'code' => 'ISL-101',
                'group' => 'Arts',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Islamic History & Culture 2nd Paper',
                'code' => 'ISL-102',
                'group' => 'Arts',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Civics 1st Paper',
                'code' => 'CIV-101',
                'group' => 'Arts',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Civics 2nd Paper',
                'code' => 'CIV-102',
                'group' => 'Arts',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Economics 1st Paper',
                'code' => 'ECO-101',
                'group' => 'Arts',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Economics 2nd Paper',
                'code' => 'ECO-102',
                'group' => 'Arts',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Logic 1st Paper',
                'code' => 'LOG-101',
                'group' => 'Arts',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Logic 2nd Paper',
                'code' => 'LOG-102',
                'group' => 'Arts',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Sociology 1st Paper',
                'code' => 'SOC-101',
                'group' => 'Arts',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Sociology 2nd Paper',
                'code' => 'SOC-102',
                'group' => 'Arts',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Geography 1st Paper',
                'code' => 'GEO-101',
                'group' => 'Arts',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Geography 2nd Paper',
                'code' => 'GEO-102',
                'group' => 'Arts',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Psychology 1st Paper',
                'code' => 'PSY-101',
                'group' => 'Arts',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Psychology 2nd Paper',
                'code' => 'PSY-102',
                'group' => 'Arts',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Social Work 1st Paper',
                'code' => 'SWK-101',
                'group' => 'Arts',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Social Work 2nd Paper',
                'code' => 'SWK-102',
                'group' => 'Arts',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],

            // ==================== COMMERCE GROUP SUBJECTS ====================
            [
                'name' => 'Accounting 1st Paper',
                'code' => 'ACC-101',
                'group' => 'Commerce',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Accounting 2nd Paper',
                'code' => 'ACC-102',
                'group' => 'Commerce',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Business Organization & Management 1st Paper',
                'code' => 'BOM-101',
                'group' => 'Commerce',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Business Organization & Management 2nd Paper',
                'code' => 'BOM-102',
                'group' => 'Commerce',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Finance, Banking & Insurance 1st Paper',
                'code' => 'FIN-101',
                'group' => 'Commerce',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Finance, Banking & Insurance 2nd Paper',
                'code' => 'FIN-102',
                'group' => 'Commerce',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Production Management & Marketing 1st Paper',
                'code' => 'PMM-101',
                'group' => 'Commerce',
                'is_4th_subject' => false,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Production Management & Marketing 2nd Paper',
                'code' => 'PMM-102',
                'group' => 'Commerce',
                'is_4th_subject' => false,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],

            // ==================== OPTIONAL/4TH SUBJECTS ====================
            [
                'name' => 'Agriculture 1st Paper',
                'code' => 'AGR-101',
                'group' => 'Science',
                'is_4th_subject' => true,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => true,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 50,
                'practical_marks' => 25,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Agriculture 2nd Paper',
                'code' => 'AGR-102',
                'group' => 'Science',
                'is_4th_subject' => true,
                'has_first_paper' => false,
                'has_second_paper' => true,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => true,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 50,
                'practical_marks' => 25,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Statistics',
                'code' => 'STAT-101',
                'group' => 'Science',
                'is_4th_subject' => true,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Computer Science',
                'code' => 'CSE-101',
                'group' => 'Science',
                'is_4th_subject' => true,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => true,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 30,
                'cq_marks' => 50,
                'practical_marks' => 20,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Music',
                'code' => 'MUS-101',
                'group' => 'Arts',
                'is_4th_subject' => true,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => false,
                'has_cq' => true,
                'has_practical' => true,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => null,
                'cq_marks' => 50,
                'practical_marks' => 50,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Home Economics',
                'code' => 'HEC-101',
                'group' => 'Arts',
                'is_4th_subject' => true,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => true,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 50,
                'practical_marks' => 25,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Arabic',
                'code' => 'ARB-101',
                'group' => 'Arts',
                'is_4th_subject' => true,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Sanskrit',
                'code' => 'SAN-101',
                'group' => 'Arts',
                'is_4th_subject' => true,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Pali',
                'code' => 'PAL-101',
                'group' => 'Arts',
                'is_4th_subject' => true,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Economics (for Commerce)',
                'code' => 'ECO-COM-101',
                'group' => 'Commerce',
                'is_4th_subject' => true,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Business Entrepreneurship',
                'code' => 'BEN-101',
                'group' => 'Commerce',
                'is_4th_subject' => true,
                'has_first_paper' => true,
                'has_second_paper' => false,
                'has_mcq' => true,
                'has_cq' => true,
                'has_practical' => false,
                'total_marks' => 100,
                'pass_marks' => 33,
                'mcq_marks' => 25,
                'cq_marks' => 75,
                'practical_marks' => null,
                'status' => 'active',
                'created_at' => $now,
                'updated_at' => $now,
            ],
        ];

        // Delete existing subjects if they exist (by code) to avoid duplicates
        foreach ($subjects as $subject) {
            DB::table('subjects')->where('code', $subject['code'])->delete();
        }

        // Insert all subjects
        DB::table('subjects')->insert($subjects);

        $this->command->info('✅ Successfully added ' . count($subjects) . ' HSC level subjects!');
        $this->command->info('📚 Core Subjects: 5 (Bangla 1st & 2nd Paper, English 1st & 2nd Paper, ICT)');
        $this->command->info('🔬 Science Group: 14 subjects');
        $this->command->info('📖 Arts Group: 20 subjects');
        $this->command->info('💼 Commerce Group: 10 subjects');
        $this->command->info('📋 Optional/4th Subjects: 13 subjects');
        $this->command->info('📊 Total: ' . count($subjects) . ' subjects added to database!');
    }
}
