@props(['title', 'value', 'icon', 'color' => 'primary', 'trend' => null])

<div class="card stat-card h-100">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-start">
            <div>
                <p class="text-muted small mb-1 text-uppercase fw-bold">{{ $title }}</p>
                <h3 class="mb-0 fw-bold text-dark">{{ $value }}</h3>
            </div>
            <div class="icon-shape bg-{{ $color }} bg-opacity-10 text-{{ $color }} rounded p-3">
                <i class="bi bi-{{ $icon }} fs-4"></i>
            </div>
        </div>
        @if($trend)
            <div class="mt-3">
                <span class="badge badge-soft-{{ $trend > 0 ? 'success' : 'danger' }}">
                    <i class="bi bi-arrow-{{ $trend > 0 ? 'up' : 'down' }}"></i> {{ abs($trend) }}%
                </span>
                <span class="text-muted small ms-1">since last month</span>
            </div>
        @endif
    </div>
</div>
