@extends('admin.layouts.app')

@section('title', 'Dashboard')

@section('content')
<div class="row g-4 mb-4">
    <!-- Stat Cards -->
    <div class="col-12 col-sm-6 col-lg-3">
        @include('admin.components.stat-card', [
            'title' => 'Total Students',
            'value' => $stats['students'],
            'icon' => 'people',
            'color' => 'primary',
            'trend' => null
        ])
    </div>
    
    <div class="col-12 col-sm-6 col-lg-3">
        @include('admin.components.stat-card', [
            'title' => 'Total Batches',
            'value' => $stats['batches'],
            'icon' => 'layers',
            'color' => 'success',
            'trend' => null
        ])
    </div>

    <div class="col-12 col-sm-6 col-lg-3">
        @include('admin.components.stat-card', [
            'title' => 'Total Teachers',
            'value' => $stats['teachers'],
            'icon' => 'person-badge',
            'color' => 'info',
            'trend' => null
        ])
    </div>

    <div class="col-12 col-sm-6 col-lg-3">
        @include('admin.components.stat-card', [
            'title' => 'Active Exams',
            'value' => $stats['pending_results'],
            'icon' => 'clipboard-data',
            'color' => 'warning',
            'trend' => null
        ])
    </div>
</div>

<div class="row g-4">
    <!-- Charts / Main Content -->
    <div class="col-12 col-lg-8">
        <div class="card h-100 shadow-sm border-0">
            <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-bold">Recent Registrations</h6>
                <a href="{{ route('students.index') }}" class="btn btn-sm btn-light">View All</a>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th class="ps-4">Student</th>
                                <th>Roll</th>
                                <th>Class</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($recentStudents as $student)
                                <tr>
                                    <td class="ps-4">
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-sm rounded-circle bg-primary-subtle text-primary d-flex align-items-center justify-content-center me-2" style="width: 32px; height: 32px; font-size: 12px;">
                                                {{ substr($student->name, 0, 1) }}
                                            </div>
                                            <div>
                                                <h6 class="mb-0 text-sm fw-semibold text-dark">{{ $student->name }}</h6>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="text-sm text-muted">{{ $student->roll }}</td>
                                    <td class="text-sm text-muted">{{ $student->current_class }}</td>
                                    <td class="text-sm text-muted">{{ $student->created_at->format('M d, Y') }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="text-center py-4 text-muted small">No new students found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Right Sidebar -->
    <div class="col-12 col-lg-4">
        <!-- Quick Actions -->
        <div class="card shadow-sm border-0 mb-4">
            <div class="card-header bg-white py-3">
                <h6 class="mb-0 fw-bold">Quick Actions</h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('students.create') }}" class="btn btn-primary d-flex align-items-center justify-content-between">
                        <span><i class="bi bi-person-plus me-2"></i> Add New Student</span>
                        <i class="bi bi-chevron-right small"></i>
                    </a>
                    <a href="{{ route('exams.create') }}" class="btn btn-light border d-flex align-items-center justify-content-between hover-bg-gray-100">
                        <span><i class="bi bi-pencil-square me-2"></i> Create Exam</span>
                        <i class="bi bi-chevron-right small"></i>
                    </a>
                    <a href="{{ route('notices.create') }}" class="btn btn-light border d-flex align-items-center justify-content-between hover-bg-gray-100">
                        <span><i class="bi bi-megaphone me-2"></i> Publish Notice</span>
                        <i class="bi bi-chevron-right small"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- System Alerts / Recent Notices -->
        <div class="card shadow-sm border-0">
             <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-bold">Recent Notices</h6>
            </div>
            <div class="list-group list-group-flush">
                @forelse($recentNotices as $notice)
                    <a href="#" class="list-group-item list-group-item-action border-0 px-4 py-3">
                        <div class="d-flex w-100 justify-content-between">
                            <h6 class="mb-1 text-sm fw-semibold text-dark">{{ Str::limit($notice->title, 30) }}</h6>
                            <small class="text-muted" style="font-size: 11px;">{{ $notice->created_at->diffForHumans() }}</small>
                        </div>
                        <p class="mb-0 text-xs text-muted">{{ Str::limit(strip_tags($notice->content), 50) }}</p>
                    </a>
                @empty
                     <div class="text-center py-4 text-muted small">No recent notices.</div>
                @endforelse
            </div>
        </div>

    </div>
</div>
@endsection
