@extends('admin.layouts.app')

@section('title', 'Create New Exam')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('exams.index') }}">Exams</a></li>
    <li class="breadcrumb-item active" aria-current="page">Create</li>
@endsection

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-8">
        <form action="{{ route('exams.store') }}" method="POST">
            @csrf

            <div class="card mb-4 shadow-sm">
                <div class="card-header bg-white py-3">
                     <h6 class="mb-0 fw-bold"><i class="bi bi-pencil-square me-2 text-primary"></i>Exam Details</h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <!-- Exam Name -->
                        <div class="col-12">
                            <label for="name" class="form-label small fw-bold text-muted">Exam Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" id="name" class="form-control" placeholder="e.g. First Terminal Examination 2024" required value="{{ old('name') }}">
                            @error('name') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                        <!-- Exam Template -->
                        <div class="col-12">
                            <label for="exam_template_id" class="form-label small fw-bold text-muted">Exam Template <span class="text-danger">*</span></label>
                            <select name="exam_template_id" id="exam_template_id" class="form-select" required>
                                <option value="">Select Template</option>
                                @foreach($examTemplates as $template)
                                    <option value="{{ $template->id }}" {{ old('exam_template_id') == $template->id ? 'selected' : '' }}>{{ $template->name }}</option>
                                @endforeach
                            </select>
                            <div class="form-text small text-muted">Defines pass marks, rules, and subject configurations.</div>
                            @error('exam_template_id') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                         <!-- Dates -->
                        <div class="col-md-6">
                            <label for="start_date" class="form-label small fw-bold text-muted">Start Date <span class="text-danger">*</span></label>
                            <input type="date" name="start_date" id="start_date" class="form-control" required value="{{ old('start_date') }}">
                            @error('start_date') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="end_date" class="form-label small fw-bold text-muted">End Date</label>
                            <input type="date" name="end_date" id="end_date" class="form-control" value="{{ old('end_date') }}">
                            @error('end_date') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                         <!-- Batch -->
                        <div class="col-md-6">
                            <label for="batch_id" class="form-label small fw-bold text-muted">Batch <span class="text-danger">*</span></label>
                            <select name="batch_id" id="batch_id" class="form-select" required>
                                <option value="">Select Batch</option>
                                @foreach($batches as $batch)
                                    <option value="{{ $batch->id }}" {{ old('batch_id') == $batch->id ? 'selected' : '' }}>{{ $batch->name }}</option>
                                @endforeach
                            </select>
                            @error('batch_id') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                         <!-- Class (HSC Year) -->
                        <div class="col-md-6">
                            <label for="class" class="form-label small fw-bold text-muted">Class <span class="text-danger">*</span></label>
                            <select name="class" id="class" class="form-select" required>
                                <option value="">Select Class</option>
                                <option value="11" {{ old('class') == '11' ? 'selected' : '' }}>HSC 1st Year</option>
                                <option value="12" {{ old('class') == '12' ? 'selected' : '' }}>HSC 2nd Year</option>
                            </select>
                            @error('class') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>
                        
                         <!-- Status -->
                        <div class="col-md-6">
                            <label for="status" class="form-label small fw-bold text-muted">Status <span class="text-danger">*</span></label>
                            <select name="status" id="status" class="form-select" required>
                                <option value="upcoming" {{ old('status') == 'upcoming' ? 'selected' : '' }}>Upcoming</option>
                                <option value="open_for_entry" {{ old('status') == 'open_for_entry' ? 'selected' : '' }}>Open for Entry</option>
                                <option value="published" {{ old('status') == 'published' ? 'selected' : '' }}>Published</option>
                                <option value="archived" {{ old('status') == 'archived' ? 'selected' : '' }}>Archived</option>
                            </select>
                            @error('status') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                         <!-- Description -->
                        <div class="col-12">
                            <label for="description" class="form-label small fw-bold text-muted">Description</label>
                            <textarea name="description" id="description" class="form-control" rows="3" placeholder="Optional notes...">{{ old('description') }}</textarea>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="d-flex justify-content-end gap-2 mb-5">
                <a href="{{ route('exams.index') }}" class="btn btn-light border px-4">Cancel</a>
                <button type="submit" class="btn btn-primary px-4"><i class="bi bi-save me-1"></i> Create Exam</button>
            </div>

        </form>
    </div>
</div>
@endsection
