@extends('admin.layouts.app')

@section('title', 'Edit Exam')

@section('content')
<div class="container-fluid p-0">
    <div class="row">
        <div class="col-12">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="mb-0 fw-bold text-primary"><i class="fas fa-edit me-2"></i>Edit Exam</h5>
                        <p class="text-muted small mb-0 mt-1">Update examination details</p>
                    </div>
                    <a href="{{ route('exams.index') }}" class="btn btn-outline-secondary btn-sm">
                        <i class="fas fa-arrow-left me-1"></i> Back to List
                    </a>
                </div>

                <div class="card-body p-4">
                    <form action="{{ route('exams.update', $exam) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="row g-4">
                            <!-- Basic Information -->
                            <div class="col-12">
                                <h6 class="fw-bold border-bottom pb-2 mb-3 text-secondary">Basic Information</h6>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label fw-bold small text-uppercase">Exam Name <span class="text-danger">*</span></label>
                                    <input type="text" name="name" id="name" value="{{ old('name', $exam->name) }}" class="form-control" placeholder="e.g. First Term Examination 2024" required>
                                    @error('name') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label fw-bold small text-uppercase">Exam Template</label>
                                    <input type="text" value="{{ $exam->examTemplate->name ?? 'N/A' }}" class="form-control bg-light" disabled>
                                    <div class="form-text text-muted"><i class="fas fa-lock me-1"></i> Template rules cannot be changed</div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="batch_id" class="form-label fw-bold small text-uppercase">Batch <span class="text-danger">*</span></label>
                                    <select name="batch_id" id="batch_id" class="form-select" required>
                                        <option value="">Select Batch</option>
                                        @foreach($batches as $batch)
                                            <option value="{{ $batch->id }}" {{ old('batch_id', $exam->batch_id) == $batch->id ? 'selected' : '' }}>
                                                {{ $batch->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('batch_id') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="class" class="form-label fw-bold small text-uppercase">Class <span class="text-danger">*</span></label>
                                    <select name="class" id="class" class="form-select" required>
                                        <option value="11" {{ old('class', $exam->class) == '11' ? 'selected' : '' }}>Class XI</option>
                                        <option value="12" {{ old('class', $exam->class) == '12' ? 'selected' : '' }}>Class XII</option>
                                    </select>
                                    @error('class') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                </div>
                            </div>

                            <!-- Schedule & Status -->
                            <div class="col-12 mt-4">
                                <h6 class="fw-bold border-bottom pb-2 mb-3 text-secondary">Schedule & Status</h6>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="start_date" class="form-label fw-bold small text-uppercase">Start Date</label>
                                    <input type="date" name="start_date" id="start_date" 
                                           value="{{ old('start_date', $exam->start_date ? \Carbon\Carbon::parse($exam->start_date)->format('Y-m-d') : '') }}" 
                                           class="form-control">
                                    @error('start_date') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="end_date" class="form-label fw-bold small text-uppercase">End Date</label>
                                    <input type="date" name="end_date" id="end_date" 
                                           value="{{ old('end_date', $exam->end_date ? \Carbon\Carbon::parse($exam->end_date)->format('Y-m-d') : '') }}" 
                                           class="form-control">
                                    @error('end_date') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="status" class="form-label fw-bold small text-uppercase">Status <span class="text-danger">*</span></label>
                                    <select name="status" id="status" class="form-select" required>
                                        <option value="upcoming" {{ old('status', $exam->status) == 'upcoming' ? 'selected' : '' }}>Upcoming</option>
                                        <option value="open_for_entry" {{ old('status', $exam->status) == 'open_for_entry' ? 'selected' : '' }}>Open for Entry</option>
                                        <option value="published" {{ old('status', $exam->status) == 'published' ? 'selected' : '' }}>Published</option>
                                        <option value="archived" {{ old('status', $exam->status) == 'archived' ? 'selected' : '' }}>Archived</option>
                                    </select>
                                    @error('status') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                </div>
                            </div>
                        </div>

                        <div class="text-end mt-4 pt-3 border-top">
                            <a href="{{ route('exams.index') }}" class="btn btn-light me-2">Cancel</a>
                            <button type="submit" class="btn btn-primary px-4 fw-bold shadow-sm">
                                <i class="fas fa-save me-2"></i> Update Exam
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

