@extends('admin.layouts.app')

@section('title', 'Exam Management')

@section('breadcrumb')
    <li class="breadcrumb-item active" aria-current="page">Exams</li>
@endsection

@section('actions')
    <a href="{{ route('exams.create') }}" class="btn btn-primary d-flex align-items-center">
        <i class="bi bi-plus-lg me-2"></i> Create Exam
    </a>
@endsection

@section('content')

<!-- Search & Filter -->
@if(isset($currentBatch))
    <div class="card border-0 shadow-sm mb-4 bg-danger text-white overflow-hidden position-relative">
        <div class="card-body p-4 position-relative z-1">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                     <h5 class="mb-1 text-white-50 small text-uppercase fw-bold">Active Batch</h5>
                    <h3 class="mb-0 fw-bold text-white">{{ $currentBatch->name }}</h3>
                </div>
                <a href="{{ route('exams.index') }}" class="btn btn-light text-danger fw-bold shadow-sm">
                    <i class="bi bi-arrow-left me-1"></i> Back to Folders
                </a>
            </div>
        </div>
        <!-- Decorative bg circle -->
        <div class="position-absolute top-0 end-0 p-3 opacity-25">
            <i class="bi bi-journal-check display-1 text-white"></i>
        </div>
    </div>
@endif

<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('exams.index') }}" class="row g-3">
            <div class="col-md-3">
                <label class="form-label small text-muted fw-bold">Search</label>
                 <div class="input-group">
                    <span class="input-group-text bg-white border-end-0"><i class="bi bi-search text-muted"></i></span>
                    <input type="text" name="search" class="form-control border-start-0 ps-0" value="{{ request('search') }}" placeholder="Exam name...">
                </div>
            </div>

            <div class="col-md-3">
                 <label class="form-label small text-muted fw-bold">Batch</label>
                 <select name="batch_id" class="form-select">
                     <option value="">All Batches</option>
                     @foreach(($batches ?? []) as $batch)
                         <option value="{{ $batch->id }}" {{ request('batch_id') == $batch->id ? 'selected' : '' }}>
                             {{ $batch->name }}
                         </option>
                     @endforeach
                 </select>
            </div>

            <div class="col-md-3">
                <label class="form-label small text-muted fw-bold">Status</label>
                <select name="status" class="form-select">
                    <option value="">All Status</option>
                    <option value="upcoming" {{ request('status')=='upcoming' ? 'selected' : '' }}>Upcoming</option>
                    <option value="ongoing" {{ request('status')=='ongoing' ? 'selected' : '' }}>Ongoing</option>
                    <option value="completed" {{ request('status')=='completed' ? 'selected' : '' }}>Completed</option>
                </select>
            </div>

            <div class="col-md-3 d-flex align-items-end">
                <button class="btn btn-dark w-100">Filter</button>
            </div>
        </form>
    </div>
</div>

<!-- Exams List -->
<div class="card">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light text-muted small text-uppercase">
                    <tr>
                        <th class="ps-4">Exam Details</th>
                        <th>Target Batch</th>
                        <th>Class</th>
                        <th>Template</th>
                        <th>Status</th>
                        <th class="text-end pe-4">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($exams as $exam)
                        <tr>
                            <td class="ps-4">
                                <div class="d-flex align-items-center">
                                    <div class="rounded p-2 bg-light border me-3 text-center" style="min-width: 50px;">
                                        <div class="small fw-bold text-uppercase text-muted">{{ $exam->start_date ? \Carbon\Carbon::parse($exam->start_date)->format('M') : 'N/A' }}</div>
                                        <div class="h5 mb-0 fw-bold text-dark">{{ $exam->start_date ? \Carbon\Carbon::parse($exam->start_date)->format('d') : '--' }}</div>
                                    </div>
                                    <div>
                                        <h6 class="mb-0 text-dark fw-bold">{{ $exam->name }}</h6>
                                        <div class="text-muted small">
                                            @if($exam->end_date)
                                                Ends: {{ \Carbon\Carbon::parse($exam->end_date)->format('M d, Y') }}
                                            @else
                                                <span class="text-muted fst-italic">No end date</span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-info bg-opacity-10 text-info border border-info border-opacity-25">{{ $exam->batch->name ?? 'N/A' }}</span>
                            </td>
                            <td>
                                <span class="badge bg-primary bg-opacity-10 text-primary border border-primary border-opacity-25">
                                    {{ $exam->class == 11 ? 'Class XI' : 'Class XII' }}
                                </span>
                            </td>
                            <td>
                                @if($exam->examTemplate)
                                    <div class="d-flex align-items-center">
                                        <i class="bi bi-file-earmark-text text-secondary me-2"></i>
                                        <span>{{ $exam->examTemplate->name }}</span>
                                    </div>
                                @else
                                    <span class="text-muted small">No Template</span>
                                @endif
                            </td>
                            <td>
                                @if($exam->status === 'upcoming')
                                    <span class="badge bg-warning text-dark border border-warning">Upcoming</span>
                                @elseif($exam->status === 'open_for_entry')
                                    <span class="badge bg-success border border-success">Open for Entry</span>
                                @elseif($exam->status === 'published')
                                    <span class="badge bg-info text-dark border border-info">Published</span>
                                @elseif($exam->status === 'archived')
                                    <span class="badge bg-secondary border border-secondary">Archived</span>
                                @else
                                    <span class="badge bg-light text-dark border">{{ ucfirst($exam->status) }}</span>
                                @endif
                            </td>
                            <td class="text-end pe-4">
                                <div class="btn-group">
                                    <a href="{{ route('exams.show', $exam) }}" class="btn btn-sm btn-light text-primary" data-bs-toggle="tooltip" title="View details"><i class="bi bi-eye"></i></a>
                                    <a href="{{ route('exams.edit', $exam) }}" class="btn btn-sm btn-light text-warning" data-bs-toggle="tooltip" title="Edit exam"><i class="bi bi-pencil-square"></i></a>
                                    
                                    <form action="{{ route('exams.destroy', $exam) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this exam?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-light text-danger" title="Delete"><i class="bi bi-trash"></i></button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="py-5 text-center text-muted">
                                <div class="mb-3">
                                    <i class="bi bi-pencil-square fs-1 text-secondary opacity-50"></i>
                                </div>
                                <p class="mb-1">No exams found.</p>
                                <a href="{{ route('exams.create') }}" class="btn btn-sm btn-primary mt-2">Create First Exam</a>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
    @if($exams->hasPages())
        <div class="card-footer bg-white border-top-0 py-3">
             {{ $exams->withQueryString()->links('pagination::bootstrap-5') }}
        </div>
    @endif
</div>
@endsection
